# 开发建议

对于开发，以下列举五个打印机设定相关功能：

- 标签基础设定

  > 若使用过程中有以下情况，建议增加该设定版面，如：
  >
  > - 会使用不同规格标签：不规格标签需要设定标签大小，或设定标签传感器类型。
  > - 会使用不同材质标签：不同材质标签需要设定打印热度

- RFID设定

  > 若使用过程中有以下情况，建议增加该设定版面，如：
  >
  > - 使用RFID打印

- 出纸方向设定

  > 如使用过程中有以下情况，建议增加该设定版面，如：
  >
  > - 需要依据纸张表面图案决定打印内容方向

- 其他设定

  > 该功能用于后期SDK更新、维护、问题排除，建议增加。

- 偏移

  > 该功能用于特殊纸张，或用于内容微调时使用。

## 标签基础设定

建议依据`setup`方法与`genericDefault`方法做一个标签的基础设定版面。

- 卷标高度、宽度、间隙高度：

  可以依据使用的纸张，设定为选择框或输入框，若为输入框，需要对用户输入的数据进行校验，否则可能会导致打印机卡死。

- 热度、速度、标签传感器：建议使用选择框。

- 间隙偏移量：建议默认为0即可

- 一般设定初始化：建议做成按钮，点击触发`genericaDefault`方法

- 设定：建议做成按钮，点击触发`setup`方法。

> 以上仅为建议，也可依据自行使用习惯，对该方法进行调用。

![一般设定](./assets/一般设定.png)

## RFID设定

建议依据`LabelCalibration`、`rfidSetupDefault`、`Set_RFIDPorcedure`方法做一个RFID设定的版面，若使用RFID功能，建议添加该功能。

- 标签类型、最大无效标签书、标签无效时的动作、无效标签打印速度、标签重试次数：

  建议依据方法中参数的信息，做成选项框。

- 读写位置：建议做成输入框，单位为mm，需要对用户输入的数据进行校验，否则可能导致打印机卡死。

- 无效标记长度：

  可以做成输入框或者选择框，若为输入框，需要校验输入的数据，否则可能导致打印机卡死。无效标记为0时，为关闭无效标记。

- RFID校准：建议做成按钮，点击时触发`LabelCalibration`方法

- RFID设定初始化：建议做成按钮，点击时触发`rfidSetupDefault`方法

- 设定：建议做成按钮，点击时触发`Set_RFIDPorcedure`方法

> 以上仅为建议，也可依据系统决定是否需要以上功能。

![RFID设定](./assets/RFID设定.png)

## 出纸方向设定

建议依据`setDirectionAndMirror`方法，做一个可以更改出纸方向的设定

- 出纸方向、是否镜像：建议依据方法的参数信息，做成选择框。
- 设定：建议做成按钮，点击时触发`setDirectionAndMirror`方法

> 出纸方向可以单独进行设定，也可以在标签内容指令中加入sendCommand("DIRECTION 1\r\n")的方法决定每张标签的方向(sendCommand具体调用方法请参考SDK说明文档，此处只做说明。)
>
> 若标签内容中以加入DIRECTION的方法，可以不增加此功能。

![出纸方向](./assets/出纸方向.png)

## 其他设定

建议依据`getSDKVersion`方法和`sensorDefault`方法增加获取SDK版本号与传感器初始化设定功能。

![其他设定](./assets/其他设定.png)

## 偏移、裁切、打印后动作设定

以下功能使用频率较少，可以依据系统以及实际使用情况决定是否需要添加下述方法。

- Y轴偏移量：可做成选择框或输入框。若为输入框，需要校验输入的数据，否则可能导致打印机卡死。
- 额外出纸偏移设定：可做成选择框或输入框。若为输入框，需要校验输入的数据，否则可能导致打印机卡死。
- 裁切模式：建议做成选择框，默认为不裁切。
- 裁切频率：可做成选择框或输入框。若为输入框，需要校验输入的数据，否则可能导致打印机卡死。
- 打印后动作设定：建议做成选择框，默认为撕纸模式。

![裁切、偏移、打印后动作](./assets/裁切、偏移、打印后动作.png)